/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRPlayerData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;

public class LOTRPacketInvasionWins
implements IMessage {
    private UUID playerUUID;
    private int invasionWins;

    public LOTRPacketInvasionWins() {
    }

    public LOTRPacketInvasionWins(UUID playerUUID, int invasionWins) {
        this.playerUUID = playerUUID;
        this.invasionWins = invasionWins;
    }

    public void toBytes(ByteBuf data) {
        data.writeLong(this.playerUUID.getMostSignificantBits());
        data.writeLong(this.playerUUID.getLeastSignificantBits());
        data.writeInt(this.invasionWins);
    }

    public void fromBytes(ByteBuf data) {
        long mostSigBits = data.readLong();
        long leastSigBits = data.readLong();
        this.playerUUID = new UUID(mostSigBits, leastSigBits);
        this.invasionWins = data.readInt();
    }

    public static class Handler
    implements IMessageHandler<LOTRPacketInvasionWins, IMessage> {
        public IMessage onMessage(LOTRPacketInvasionWins message, MessageContext context) {
            MinecraftServer server = MinecraftServer.func_71276_C();
            EntityPlayerMP player = server.func_71203_ab().func_152612_a(message.playerUUID.toString());
            if (player != null) {
                LOTRPlayerData pd = LOTRLevelData.getData((EntityPlayer)player);
                pd.setInvasionWins(message.invasionWins);
            }
            return null;
        }
    }
}

